%% Vorlage für Präsentationen mit LaTeX Beamer im aau-Design


\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{sdqbeamer}[2025-03-01 v4.0.0 SDQ Beamer class]

\RequirePackage[utf8]{inputenc}
\RequirePackage[T1]{fontenc}

\newif\ifsectionnavigationoption
\newif\ifsectionnavigation
\sectionnavigationoptiontrue
\newif\ifgerman
\newif\iffranklin
\newif\ifsmallfooterfont
\newif\ifaaugrid

\def\groupname#1{\def\@groupname{#1}}
\def\groupnamewidth#1{\def\@groupnamewidth{#1}}

% siehe README.md
\DeclareOption{de}{
  \germantrue
  \PassOptionsToPackage{autostyle}{csquotes}
  }
\DeclareOption{en}{
  \germanfalse
  }
\DeclareOption{navbaroff}{
  \sectionnavigationoptionfalse
}
\DeclareOption{smallfoot}{
  \smallfooterfonttrue
}
\DeclareOption{bigfoot}{
  \smallfooterfontfalse
}
\DeclareOption{helvet}{
  \franklinfalse
}
\DeclareOption{franklin}{
  \franklintrue
}
\DeclareOption{aaugrid}{
  \aaugridtrue
}

\ExecuteOptions{de,bigfoot,franklin}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{beamer}}

\ProcessOptions\relax

% In der PowerPoint-Vorlage ist die Schrift 16 pt groß. Dies wird von LaTeX aber standardmäßig nicht angeboten.
% Daher wurden 17 pt als Standardschriftgröße gewählt. Das ergibt:
%
% \tiny         = 10pt
% \scriptsize   = 11pt
% \footnotesize = 12pt
% \small        = 14pt
% \normalsize   = 17pt
% \large        = 20pt
% \Large        = 25pt
% \LARGE        = 30pt
% \huge         = 36pt
% \Huge         = 48pt
% \HUGE         = 60pt 
%
% onlytextwidth läßt Spalten nur innerhalb der Ränder erscheinen.
\LoadClass[17pt,utf8,onlytextwidth]{beamer}

% Babel-Paket wird nur bei deutscher Sprache benötigt
\ifgerman
  \RequirePackage[ngerman]{babel}
\fi
\RequirePackage{csquotes}
\RequirePackage{hyperref}
\RequirePackage[absolute,overlay]{textpos}

%% ┏━━━━━━━━━━━━━┓
%% ┃ Typographie ┃
%% ┗━━━━━━━━━━━━━┛

% Overleaf-friendly Roboto configuration
\usepackage[T1]{fontenc}
\usepackage{roboto}  % CTAN Roboto package
\usepackage{microtype}

% Prevent warnings about font size replacements
\usepackage{fix-cm}

% Optional: If you want more font weights
\usepackage{newtxtext}

% Semibold (keeping your original definition)
\DeclareRobustCommand{\sbseries}{\fontseries{sb}\selectfont}
\DeclareTextFontCommand{\textsb}{\sbseries}

% Font Configuration
\renewcommand{\familydefault}{\sfdefault}  % Sans-serif as default

% Beamer font settings
\setbeamerfont{title}{series=\bfseries, size=\Huge}
\setbeamerfont{frametitle}{series=\bfseries, size=\huge}
\setbeamerfont{framesubtitle}{series=\bfseries, size=\LARGE}
\setbeamerfont{section in toc}{family=\rmfamily, series=\bfseries}

\setbeamerfont{subtitle}{series=\bfseries, size=\normalsize}
\setbeamerfont{author}{series=\mdseries, size=\normalsize}
\setbeamerfont{date}{series=\mdseries, size=\normalsize}

% Aufzählungen
\setbeamertemplate{itemize items}[square]

% Boxen
\setbeamerfont{highlight box}{series=\bfseries, size=\normalsize}
\setbeamerfont{standard box}{series=\bfseries, size=\normalsize}

%% ┏━━━━━━━━━━━━━━┓
%% ┃ /Typographie ┃
%% ┗━━━━━━━━━━━━━━┛

%% ┏━━━━━━━━━━━━━━━┓
%% ┃ Folien-Layout ┃
%% ┗━━━━━━━━━━━━━━━┛

% Seitenverhältnis

\RequirePackage{geometry}
\geometry{papersize={33.867cm,19.05cm}}

% Ränder laut pptx: 1,03 cm
\newlength{\aauoutermargin}
\setlength{\aauoutermargin}{1.03cm}
% Höhe der Fußzeile laut pptx: 1,62cm
\newlength{\aaubottom}
\setlength{\aaubottom}{1.62cm}
% Abstände im Raster
\newlength{\aaucolumn}
\setlength{\aaucolumn}{4.8cm}
\newlength{\aaucolumnsep}
\setlength{\aaucolumnsep}{0.6cm}
\newlength{\aaurow}
\setlength{\aaurow}{2.8cm}
\newlength{\aaurowsep}
\setlength{\aaurowsep}{0.6cm}

% Position der vertikalen Hilfslinien
\newlength{\aaucolumnoneleft}
\setlength{\aaucolumnoneleft}{\aauoutermargin}
\newlength{\aaucolumnoneright}
\setlength{\aaucolumnoneright}{\dimexpr\aauoutermargin+\aaucolumn\relax}

\newlength{\aaucolumntwoleft}
\setlength{\aaucolumntwoleft}{\dimexpr\aauoutermargin+\aaucolumn+\aaucolumnsep\relax}
\newlength{\aaucolumntworight}
\setlength{\aaucolumntworight}{\dimexpr\aauoutermargin+2\aaucolumn+\aaucolumnsep\relax}

\newlength{\aaucolumnthreeleft}
\setlength{\aaucolumnthreeleft}{\dimexpr\aauoutermargin+2\aaucolumn+2\aaucolumnsep\relax}
\newlength{\aaucolumnthreeright}
\setlength{\aaucolumnthreeright}{\dimexpr\aauoutermargin+3\aaucolumn+2\aaucolumnsep\relax}

\newlength{\aaucolumnfourleft}
\setlength{\aaucolumnfourleft}{\dimexpr\aauoutermargin+3\aaucolumn+3\aaucolumnsep\relax}
\newlength{\aaucolumnfourright}
\setlength{\aaucolumnfourright}{\dimexpr\aauoutermargin+4\aaucolumn+3\aaucolumnsep\relax}

\newlength{\aaucolumnfiveleft}
\setlength{\aaucolumnfiveleft}{\dimexpr\aauoutermargin+4\aaucolumn+4\aaucolumnsep\relax}
\newlength{\aaucolumnfiveright}
\setlength{\aaucolumnfiveright}{\dimexpr\aauoutermargin+5\aaucolumn+4\aaucolumnsep\relax}

\newlength{\aaucolumnsixleft}
\setlength{\aaucolumnsixleft}{\dimexpr\aauoutermargin+5\aaucolumn+5\aaucolumnsep\relax}
\newlength{\aaucolumnsixright}
\setlength{\aaucolumnsixright}{\dimexpr\aauoutermargin+6\aaucolumn+5\aaucolumnsep\relax}

% Position der horizontalen Hilfslinien
\newlength{\aaurowonetop}
\setlength{\aaurowonetop}{\aauoutermargin}
\newlength{\aaurowonebottom}
\setlength{\aaurowonebottom}{\dimexpr\aauoutermargin+\aaurow\relax}

\newlength{\aaurowtwotop}
\setlength{\aaurowtwotop}{\dimexpr\aauoutermargin+\aaurow+\aaurowsep\relax}
\newlength{\aaurowtwobottom}
\setlength{\aaurowtwobottom}{\dimexpr\aauoutermargin+2\aaurow+\aaurowsep\relax}

\newlength{\aaurowthreetop}
\setlength{\aaurowthreetop}{\dimexpr\aauoutermargin+2\aaurow+2\aaurowsep\relax}
\newlength{\aaurowthreebottom}
\setlength{\aaurowthreebottom}{\dimexpr\aauoutermargin+3\aaurow+2\aaurowsep\relax}

\newlength{\aaurowfourtop}
\setlength{\aaurowfourtop}{\dimexpr\aauoutermargin+3\aaurow+3\aaurowsep\relax}
\newlength{\aaurowfourbottom}
\setlength{\aaurowfourbottom}{\dimexpr\aauoutermargin+4\aaurow+3\aaurowsep\relax}

\newlength{\aaurowfivetop}
\setlength{\aaurowfivetop}{\dimexpr\aauoutermargin+4\aaurow+4\aaurowsep\relax}
\newlength{\aaurowfivebottom}
\setlength{\aaurowfivebottom}{\dimexpr\aauoutermargin+5\aaurow+4\aaurowsep\relax}

% Breite von Elementen, die mehrere Spalten umfassen
\newlength{\aauonecolumn}
\setlength{\aauonecolumn}{\aaucolumn}
\newlength{\aautwocolumns}
\setlength{\aautwocolumns}{\dimexpr2\aaucolumn+\aaucolumnsep\relax}
\newlength{\aauthreecolumns}
\setlength{\aauthreecolumns}{\dimexpr3\aaucolumn+2\aaucolumnsep\relax}
\newlength{\aaufourcolumns}
\setlength{\aaufourcolumns}{\dimexpr4\aaucolumn+3\aaucolumnsep\relax}
\newlength{\aaufivecolumns}
\setlength{\aaufivecolumns}{\dimexpr5\aaucolumn+4\aaucolumnsep\relax}
\newlength{\aausixcolumns}
\setlength{\aausixcolumns}{\dimexpr6\aaucolumn+5\aaucolumnsep\relax}

% Breite von Elementen, die mehrere Zeilen umfassen
\newlength{\aauonerow}
\setlength{\aauonerow}{\aaurow}
\newlength{\aautworows}
\setlength{\aautworows}{\dimexpr2\aaurow+\aaurowsep\relax}
\newlength{\aauthreerows}
\setlength{\aauthreerows}{\dimexpr3\aaurow+2\aaurowsep\relax}
\newlength{\aaufourrows}
\setlength{\aaufourrows}{\dimexpr4\aaurow+3\aaurowsep\relax}
\newlength{\aaufiverows}
\setlength{\aaufiverows}{\dimexpr5\aaurow+4\aaurowsep\relax}

% Hintergrund-Raster sichtbar
% Nach Vorlagen-pptx
\defbeamertemplate{background canvas}{aaugrid}{
  \begin{pgfpicture}{0pt}{0pt}{\paperwidth}{\paperheight}
    % horizontal
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowonetop}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowonetop}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowonebottom}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowonebottom}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowtwotop}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowtwotop}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowtwobottom}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowtwobottom}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowthreetop}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowthreetop}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowthreebottom}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowthreebottom}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowfourtop}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowfourtop}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowfourbottom}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowfourbottom}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowfivetop}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowfivetop}}
    \pgfpathmoveto{\pgfpoint{0cm}{\paperheight-\aaurowfivebottom}}
    \pgfpathlineto{\pgfpoint{\paperwidth}{\paperheight-\aaurowfivebottom}}
    % vertikal
    \pgfpathmoveto{\pgfpoint{\aaucolumnoneleft}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnoneleft}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnoneright}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnoneright}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumntwoleft}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumntwoleft}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumntworight}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumntworight}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnthreeleft}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnthreeleft}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnthreeright}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnthreeright}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnfourleft}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnfourleft}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnfourright}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnfourright}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnfiveleft}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnfiveleft}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnfiveright}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnfiveright}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnsixleft}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnsixleft}{\paperheight}}
    \pgfpathmoveto{\pgfpoint{\aaucolumnsixright}{0cm}}
    \pgfpathlineto{\pgfpoint{\aaucolumnsixright}{\paperheight}}
    % zeichnen
    \pgfsetstrokecolor{aau-orange50}
    \pgfusepath{stroke}
  \end{pgfpicture}%
}

% Ränder außen
\setbeamersize{text margin left=\aauoutermargin,text margin right=\aauoutermargin} 

% keine Navigationssymbole
\setbeamertemplate{navigation symbols}{}
\setbeamercovered{invisible}
\beamer@compresstrue % Miniframes (Navigations-Punkte) für Subsections immer in einer Zeile, ohne Umbrüche

% Mehrere Folienlayouts erlauben
% siehe https://stackoverflow.com/questions/3158665/having-multiple-slide-templates-in-latex-beamer

%%
%% Standard-Layout
%%

\BeforeBeginEnvironment{frame}{%
  \restoregeometry
  % Section-Navigation wieder auf Paketoption zurücksetzen
  \ifsectionnavigationoption\sectionnavigationtrue\else\sectionnavigationfalse\fi
  % aau-Logo bunt
  \footlinelogo{rgb}
  \setbeamertemplate{frametitle}[AAU 2025]{\paperwidth}
  \setbeamertemplate{footline}[AAU 2025]
  \setbeamertemplate{background}[default]
  \setbeamertemplate{logo}{}
  \ifaaugrid\setbeamertemplate{background canvas}[aaugrid]\fi
}

% ┌───────────┐
% │ Kopfzeile │
% └───────────┘

% #1 = Breite
\defbeamertemplate{frametitle}{AAU 2025}[1]{
  % Oberkante Titeltext
  \begin{textblock*}{#1}[0,0](\aauoutermargin,\aauoutermargin)%
    {\usebeamercolor[fg]{frametitle}\usebeamerfont{frametitle}\insertframetitle}%
    \ifx\insertframesubtitle\@empty\else\\\fi
    {\usebeamercolor[fg]{framesubtitle}\usebeamerfont{framesubtitle}\insertframesubtitle}%
  \end{textblock*}%
  % Rand oben entsprechend aau-Vorlage
  \vspace{37mm}%
}

% #1 = logo
\defbeamertemplate{logo}{AAU 2025 title/toc}[1]{
  \begin{textblock*}{24mm}(297.5mm,\aauoutermargin)
  \includegraphics[width=24mm]{logos/#1} 
  \end{textblock*}
  \vspace{37mm}%
}

% ┌────────────┐
% │ /Kopfzeile │
% └────────────┘

% ┌──────────┐
% │ Fußzeile │
% └──────────┘

% Anpassung der Fußzeile für zweizeilige Titel
\newlength{\aaufooterbaselinecorrection}

% aau-Logo (rgb, white, black)
\def\footlinelogo#1{\def\@footlinelogo{#1}}

% kleiner Text nur, wenn "smallfoot" gewählt
\ifsmallfooterfont
    % 11pt wie in offiziellen Vorlage
    \setbeamerfont{footer}{size=\scriptsize}
    \setlength{\aaufooterbaselinecorrection}{2pt}
  \else
    % 12pt, besser lesbar
    \setbeamerfont{footer}{size=\footnotesize}
    \setlength{\aaufooterbaselinecorrection}{3pt}
\fi

%
% Section-Punkte, die mit der Schriftgröße skalieren
%
% angepaßt von https://tex.stackexchange.com/questions/292070/beamer-navigation-bar-too-long
\defbeamertemplate{mini frame}{scaled circle}
{%
  \usebeamerfont{footer}%
  \begin{pgfpicture}{0pt}{0pt}{1ex}{1ex}
    \pgfsetlinewidth{.13ex}
    \pgfpathcircle{\pgfpoint{.5ex}{.5ex}}{.5ex}
    \pgfusepath{fill,stroke}
  \end{pgfpicture}%
}
[action]
{
  \usebeamerfont{footer}%
  \setbeamersize{mini frame size=1.4ex,mini frame offset=.4ex}
}

\defbeamertemplate{mini frame in current section}{scaled circle}
{%
  \usebeamerfont{footer}%
  \begin{pgfpicture}{0pt}{0pt}{1ex}{1ex}
    \pgfsetlinewidth{.13ex}
    \pgfpathcircle{\pgfpoint{.5ex}{.5ex}}{.5ex}
    \pgfusepath{stroke}
  \end{pgfpicture}%
}

\defbeamertemplate{mini frame in current subsection}{scaled circle}
{%
  \usebeamerfont{footer}%
  \begin{pgfpicture}{0pt}{0pt}{1ex}{1ex}
    \pgfsetlinewidth{.13ex}
    \pgfpathcircle{\pgfpoint{.5ex}{.5ex}}{.5ex}
    \pgfusepath{stroke}
  \end{pgfpicture}%
}

\defbeamertemplate{mini frame}{scaled rectangle}
{%
  \usebeamerfont{footer}%
  \begin{pgfpicture}{0pt}{0pt}{1ex}{1ex}
    \pgfsetlinewidth{.1ex}
    \pgfpathrectangle{\pgfpoint{0ex}{0ex}}{\pgfpoint{1ex}{1ex}}
    \pgfusepath{fill,stroke}
  \end{pgfpicture}%
}
[action]
{
  \usebeamerfont{footer}%
  \setbeamersize{mini frame size=1.4ex,mini frame offset=.4ex}
}

\defbeamertemplate{mini frame in current section}{scaled rectangle}
{%
  \usebeamerfont{footer}%
  \begin{pgfpicture}{0pt}{0pt}{1ex}{1ex}
    \pgfsetlinewidth{.1ex}
    \pgfpathrectangle{\pgfpoint{0ex}{0ex}}{\pgfpoint{1ex}{1ex}}
    \pgfusepath{stroke}
  \end{pgfpicture}%
}

\defbeamertemplate{mini frame in current subsection}{scaled rectangle}
{%
  \usebeamerfont{footer}%
  \begin{pgfpicture}{0pt}{0pt}{1ex}{1ex}
    \pgfsetlinewidth{.1ex}
    \pgfpathrectangle{\pgfpoint{0ex}{0ex}}{\pgfpoint{1ex}{1ex}}
    \pgfusepath{stroke}
  \end{pgfpicture}%
}

\setbeamertemplate{mini frame}[scaled circle]
\setbeamertemplate{mini frame in current section}[scaled circle]
\setbeamertemplate{mini frame in current subsection}[scaled circle]

%%
%% /Section-Punkte, die mit der Schriftgröße skalieren
%%

\setbeamerfont{page number in head/foot}{series=\bfseries}

\newlength{\aaubottomdepth}
\newlength{\aaubottomheight}
\newlength{\aaufootergroupwidth}

% Standardfußzeile Vollbreite
\defbeamertemplate{footline}{AAU 2025}{%
  %% die "%" am Ende sind nötig, damit keine Abstände eingefügt werden
  % Falls kein Gruppenname angegeben, die ganze Breite der Fußzeile für den Titel nutzen.
  \ifdefined\@groupname%
    \ifx\@groupname\empty%
      \setlength{\aaufootergroupwidth}{0mm}%
      \else%
      % Falls die Breite des Gruppennamens definiert ist, diese nehmen, sonst 89 mm
      \ifdefined\@groupnamewidth%
        \setlength{\aaufootergroupwidth}{\@groupnamewidth}%
        \else%
        \setlength{\aaufootergroupwidth}{89mm}%
      \fi%
    \fi%
  \else%
      \setlength{\aaufootergroupwidth}{0mm}%
  \fi%
  \usebeamerfont{footer}%
  % Baseline so setzen, dass Text ungefähr mittig
  \setlength{\aaubottomdepth}{\dimexpr.5\aaubottom-.3\baselineskip\relax}%
  \setlength{\aaubottomheight}{\dimexpr.5\aaubottom+.7\baselineskip\relax}%
  %
  % Ränder rechts und links optisch durch Ausprobieren gesetzt
  \ifsectionnavigation%
    \begin{beamercolorbox}[wd=\paperwidth, leftskip=7.5mm, rightskip=7.5mm]{}%
      \insertnavigation{\dimexpr\paperwidth-15mm\relax}%
    \end{beamercolorbox}%
  \fi%
  \leavevmode%
  \aaufootlinepagenumber%
  \aaufootlinedate%
  % Die Boxen mit dem Titel und dem Gruppennamen sind vertikal zentriert, damit auch zweizeilige Texte schön aussehen
  % Daher müssen sie um \aaubottomdepth nach unten verschoben werden
  \raisebox{-\aaubottomdepth}{%
    % Die Box hat daher auch Höhe \aaubottom und Tiefe 0mm
    \aaufootlinetitle{\dimexpr243mm-\aaufootergroupwidth\relax}%
    \ifdefined\@groupname%
      \aaufootlinegroupname%
    \fi% 
  }%
  % AAU logo
  \ifdefined\@footlinelogo\else\footlinelogo{rgb}\fi
  \aaufootlinelogo{aaulogo_\@footlinelogo}%
}

% Fußzeile variabler Breite für Folien mit vollflächigem Bild-Anteil: ohne Section-Navigation, ohne Gruppennamen ohne Bild
\defbeamertemplate{footline}{AAU 2025 picture}[1]{%
  \usebeamerfont{footer}%
  % Baseline so setzen, dass Text ungefähr mittig
  \setlength{\aaubottomdepth}{\dimexpr.5\aaubottom-.3\baselineskip\relax}%
  \setlength{\aaubottomheight}{\dimexpr.5\aaubottom+.7\baselineskip\relax}%
  \leavevmode%
  \aaufootlinepagenumber%
  \aaufootlinedate%
  % Die Box mit dem Titel ist sind vertikal zentriert, damit auch zweizeilige Texte schön aussehen
  % Daher müssen sie um \aaubottomdepth nach unten verschoben werden
  \raisebox{-\aaubottomdepth}{%
    % Die Box hat daher auch Höhe \aaubottom und Tiefe 0mm
    \aaufootlinetitle{#1}%
  }%
  % Kein Gruppenname
  \hskip\dimexpr24mm-#1\relax%

}

% Seitennummer
\newcommand{\aaufootlinepagenumber}{%
  \begin{beamercolorbox}[wd=\dimexpr\aauoutermargin+16mm\relax, ht=\aaubottomheight, dp=\aaubottomdepth, leftskip=\aauoutermargin]{footer}
      \usebeamerfont{page number in head/foot}%
      \strut\insertframenumber{}/\inserttotalframenumber%
  \end{beamercolorbox}%
}

% Datum
\newcommand{\aaufootlinedate}{%
  \begin{beamercolorbox}[wd=31mm, ht=\aaubottomheight, dp=\aaubottomdepth]{footer}%
      \usebeamerfont{date in head/foot}%
      \strut\insertshortdate%
  \end{beamercolorbox}%
}

% Autor/Titel in Breite #1
\newcommand{\aaufootlinetitle}[1]{%
    \begin{beamercolorbox}[wd=#1, ht=\aaubottom, dp=0mm]{footer}%
        % Inhalt vertikal zentrieren; Anpassung um 1.5 pt, damit bei einzeiligem Inhalt genau die Baseline der Blöcke mit Seitenzahl und Datum getroffen wird
        \vbox to\aaubottom{\vfill\vskip\aaufooterbaselinecorrection%
          \strut\beamer@shortauthor\ifx\beamer@shortauthor\empty\else: \fi\beamer@shorttitle%
        \vfill}%
    \end{beamercolorbox}%
}

% Gruppenname
\newcommand{\aaufootlinegroupname}{%
    \begin{beamercolorbox}[wd=\aaufootergroupwidth, ht=\aaubottom, dp=0mm]{footer}
        \vbox to\aaubottom{\vfill\vskip\aaufooterbaselinecorrection%
          \strut\@groupname%
        \vfill}%
    \end{beamercolorbox}%
}

% aau-Logo, Dateiname #1
\newcommand{\aaufootlinelogo}[1]{%
    \begin{beamercolorbox}[wd=10mm, ht=\aaubottomheight, dp=\aaubottomdepth]{footer}
      \raisebox{-4pt}{
        \includegraphics[width=2.5\linewidth]{logos/syssec.jpeg} 
      }
    \end{beamercolorbox}%
}

% ┌───────────┐
% │ /Fußzeile │
% └───────────┘

% ┌─────────────────┐
% │ Spezial-Layouts │
% └─────────────────┘

% Text/Bild vertikal geteilt
\define@key{beamerframe}{picture 33 vertical}[true]{%
  \aaupicturevertical{\aaucolumnfiveleft}
}

\define@key{beamerframe}{picture 50 vertical}[true]{%
  \aaupicturevertical{\aaucolumnfourleft}
}

\define@key{beamerframe}{picture 66 vertical}[true]{%
  \aaupicturevertical{\aaucolumnthreeleft}
}

\define@key{beamerframe}{picture vertical}[51]{%
  \aaupicturevertical{\dimexpr\paperwidth*(100-#1)/100\relax}
}

\newcommand{\aaupicturevertical}[1]{
  \setbeamertemplate{frametitle}[AAU 2025]{\dimexpr#1-\aauoutermargin-\aaucolumnsep\relax}
  \setbeamertemplate{footline}[AAU 2025 picture]{\dimexpr#1-\aauoutermargin-\aaucolumn\relax}
  \newgeometry{top=0.5cm,bottom=0cm,left=\aauoutermargin,right=\dimexpr\paperwidth-#1+\aaucolumnsep\relax}
  \setbeamertemplate{background}{\hskip#1\includegraphics[height=\paperheight]{\@titleimage}}
}
 
% Inhaltsverzeichnis

\define@key{beamerframe}{tableofcontents}[red]{%
  \setbeamertemplate{background}{
    \begin{beamercolorbox}[ht=\paperheight,wd=\aaucolumnsixleft]{#1 block}
    \end{beamercolorbox}
  }
  \setbeamercolor{section in toc}{fg=white}
  \setbeamercolor{subsection in toc}{fg=white}
  
\setbeamerfont{section in toc}{family=\roboto, size=\Large, series=\bfseries}
\setbeamerfont{subsection in toc}{family=\roboto, size=\large}
  
  
  \setbeamertemplate{logo}[AAU 2025 title/toc]{aaulogo_rgb}
  \setbeamertemplate{frametitle}[AAU 2025 title in toc]
  \setbeamertemplate{footline}{}
}

\defbeamertemplate{frametitle}{AAU 2025 title in toc}{
    \begin{textblock*}{\aaucolumn}(\aauoutermargin,\aauoutermargin)
      \begin{beamercolorbox}[wd=\aaucolumn]{}
        \usebeamerfont*{frametitle}{\Huge\color{white}\insertframetitle}
      \end{beamercolorbox}
    \end{textblock*}
}

% siehe README.md
\define@key{beamerframe}{picture}{%
  \titleimage{#1}
}

\define@key{beamerframe}{aaulogo}[rgb]{%
  \titlelogo{#1}
  \footlinelogo{#1}
}

% ┌──────────────────┐
% │ /Spezial-Layouts │
% └──────────────────┘

%% ┏━━━━━━━━━━━━━━━━┓
%% ┃ /Folien-Layout ┃
%% ┗━━━━━━━━━━━━━━━━┛

%% ┏━━━━━━━━━━━━┓
%% ┃ Titelseite ┃
%% ┗━━━━━━━━━━━━┛

\def\titleimage#1{\def\@titleimage{#1}}
\def\titlelogo#1{\def\@titlelogo{#1}}
\def\grouplogo#1{\def\@grouplogo{#1}}

%% Frame-Optionen

% vertikale Layouts
\define@key{beamerframe}{title white vertical}[true]{%
  \setbeamercolor*{title}{parent=title on red}
  \setbeamercolor*{subtitle}{parent=subtitle on red}
  \setbeamercolor*{title text box}{parent=red block}
  \setbeamercolor*{title logo box}{parent=white block}
  \setbeamertemplate{background}[AAU 2025 title vertical]
  \setbeamertemplate{logo}[AAU 2025 title/toc]{aaulogo_rgb}
  \setbeamertemplate{title page}[AAU 2025 vertical]
  \setbeamertemplate{frametitle}{}
  \setbeamertemplate{footline}{}
}

\define@key{beamerframe}{title blue vertical}[true]{%
  \setbeamercolor*{title}{parent=title on red}
  \setbeamercolor*{subtitle}{parent=subtitle on red}
  \setbeamercolor*{title text box}{parent=red block}
  \setbeamercolor*{title logo box}{parent=blue block}
  \setbeamertemplate{background}[AAU 2025 title vertical]
  \setbeamertemplate{logo}[AAU 2025 title/toc]{aaulogo_white}
  \setbeamertemplate{title page}[AAU 2025 vertical]
  \setbeamertemplate{frametitle}{}
  \setbeamertemplate{footline}{}
}

\define@key{beamerframe}{title royalblue vertical}[true]{%
  \setbeamercolor*{title}{parent=title on red}
  \setbeamercolor*{subtitle}{parent=subtitle on red}
  \setbeamercolor*{title text box}{parent=blue block}
  \setbeamercolor*{title logo box}{parent=white block}
  \setbeamertemplate{background}[AAU 2025 title vertical]
  \setbeamertemplate{logo}[AAU 2025 title/toc]{aaulogo_white}
  \setbeamertemplate{title page}[AAU 2025 vertical]
  \setbeamertemplate{frametitle}{}
  \setbeamertemplate{footline}{}
}
% horizontale Layouts
\define@key{beamerframe}{title red horizontal}[true]{%
  \setbeamercolor*{title}{parent=title on red}
  \setbeamercolor*{subtitle}{parent=subtitle on red}
  \setbeamercolor*{title logo box}{parent=red block}
  \setbeamercolor*{title text box}{parent=red block}
  \setbeamertemplate{background}[AAU 2025 title horizontal]
  \setbeamertemplate{frametitle}[AAU 2025 title horizontal]
  \setbeamertemplate{footline}[AAU 2025 title horizontal]
  % aau-Logo nach Definition, sonst bunt
  \ifdefined\@titlelogo\else\titlelogo{rgb}\fi
  \setbeamertemplate{logo}[AAU 2025 title/toc]{aaulogo_\@titlelogo}
  \setbeamertemplate{title page}[AAU 2025 horizontal]
}

\define@key{beamerframe}{title royalblue horizontal}[true]{%
  \setbeamercolor*{title}{parent=title on red}
  \setbeamercolor*{subtitle}{parent=subtitle on red}
  \setbeamercolor*{title logo box}{parent=blue block}
  \setbeamercolor*{title text box}{parent=blue block}
  \setbeamertemplate{background}[AAU 2025 title horizontal]
  \setbeamertemplate{frametitle}[AAU 2025 title horizontal]
  \setbeamertemplate{footline}[AAU 2025 title horizontal]
  % aau-Logo nach Definition, sonst bunt
  \ifdefined\@titlelogo\else\titlelogo{rgb}\fi
  \setbeamertemplate{logo}[AAU 2025 title/toc]{aaulogo_\@titlelogo}
  \setbeamertemplate{title page}[AAU 2025 horizontal]
}


\define@key{beamerframe}{title white horizontal}[true]{%
  \setbeamercolor*{title}{parent=title on white}
  \setbeamercolor*{subtitle}{parent=subtitle on white}
  \setbeamercolor*{title logo box}{parent=white block}
  \setbeamercolor*{title text box}{parent=white block}
  \setbeamertemplate{background}[AAU 2025 title horizontal]
  \setbeamertemplate{frametitle}[AAU 2025 title horizontal]
  \setbeamertemplate{footline}[AAU 2025 title horizontal]
  % aau-Logo nach Definition, sonst bunt
  \ifdefined\@titlelogo\else\titlelogo{rgb}\fi
  \setbeamertemplate{logo}[AAU 2025 title/toc]{aaulogo_\@titlelogo}
  \setbeamertemplate{title page}[AAU 2025 horizontal]
}

%%
%% Absolut positionierte Elemente
%%
%
% From textpos documentation (https://ctan.org/pkg/textpos)
%
% \begin{textblock}{<hsize>}[<ho>,<vo>](<hpos>,<vpos>)
%   The coordinates <ho> and <vo> are fractions of the width and height of the text
%   box, respectively, and state that the box is to be placed so that the reference point
%   (<ho>,<vo>) within the box is to be placed at the point (<hpos>,<vpos>) on the page.

% aau-Logo
\newcommand{\aautitleaaulogo}[1]{
  \begin{textblock*}{24mm}(297.5mm,\aauoutermargin)
  \includegraphics[width=24mm]{logos/#1} 
  \end{textblock*}
}

% Titel auf vertikaler Höhe #1 mit Breite #2
\newcommand{\aautitletitle}[2]{
  \begin{textblock*}{#2}(\aauoutermargin,#1)
    \begin{beamercolorbox}[wd=#2]{title}
      \usebeamerfont*{title}\inserttitle
    \end{beamercolorbox}
  \end{textblock*}
}

% Untertitel/Autor/Datum an Unterkante mit Breite #1
\newcommand{\aautitlesubtitle}[1]{
  \begin{textblock*}{#1}[0,1](\aauoutermargin,\dimexpr\paperheight-\aaubottom\relax)
    \begin{beamercolorbox}[wd=#1]{subtitle}
      \usebeamerfont*{subtitle}\insertsubtitle \ifx\@author\@empty\else\\[.2em]\fi %
      \usebeamerfont*{author}\insertauthor \ifx\@date\@empty\else~\textbar~\fi %
      \usebeamerfont*{date}\insertdate %
    \end{beamercolorbox}
  \end{textblock*}
}

%%
%% Gruppenlogo
%%

\newcommand{\aautitlegrouplogo}{
  \ifdefined\@grouplogo
    \ifx\@grouplogo\empty \else
      \includegraphics[width=37mm,height=20mm,keepaspectratio]{logos/\@grouplogo} 
    \fi % falls \grouplogo{} aufgerufen wird, kein Gruppenlogo einbinden
    \else % falls \grouplogo gar nicht aufgerufen wurde, Text anzeigen
      \colorbox{aau-purple100!20}{\parbox[b][18mm][c]{35mm}{\color{aau-purple100}\scriptsize\centering 
        \ifgerman
        Bitte Logo über \texttt{\textbackslash grouplogo\{\}} festlegen.
        \else
        Please set a logo using \texttt{\textbackslash grouplogo\{\}}.
        \fi
        }}
  \fi 
}

%%
%% Template-Definitionen
%%

\defbeamertemplate{title page}{AAU 2025 vertical}{
  \aautitletitle{\aauoutermargin}{\dimexpr\aauthreecolumns-\aaucolumnsep\relax}
  \aautitlesubtitle{\dimexpr\aauthreecolumns-\aaucolumnsep\relax}
}

% vertikales Layout

\defbeamertemplate{background}{AAU 2025 title vertical}{
    \begin{beamercolorbox}[ht=\paperheight,wd=\aaucolumnthreeright]{title text box}
    \end{beamercolorbox}%
    \begin{beamercolorbox}[ht=\paperheight,wd=\dimexpr2\aaucolumn+3\aaucolumnsep\relax]{title logo box}%
    \ifdefined\@titleimage%
      \ifx\@titleimage\empty\else%
      \includegraphics[height=\paperheight]{\@titleimage}%
      \fi%
    \fi%
    \end{beamercolorbox}%
    \begin{beamercolorbox}[ht=\paperheight,wd=\dimexpr\aaucolumn+\aauoutermargin\relax,right,rightskip=\aauoutermargin]{title logo box}
      \aautitlegrouplogo
      \vskip\aaubottom
    \end{beamercolorbox}
}

% horizontales Layout

\defbeamertemplate{title page}{AAU 2025 horizontal}{
  \aautitletitle{\aaurowfourtop}{\aaufivecolumns}
  \aautitlesubtitle{\aaufivecolumns}
  \frametitle{none} % Damit die obere Hälfte gerendert wird
}

% Im horizontalen Modus ist der Frametitle die obere Hälfte des Titels
\defbeamertemplate{frametitle}{AAU 2025 title horizontal}{
    \begin{beamercolorbox}[ht=\aaurowthreebottom,wd=\paperwidth]{title logo box}%
    \ifdefined\@titleimage%
      \ifx\@titleimage\empty\else%
      \includegraphics[width=\paperwidth]{\@titleimage}%
      \fi%
    \fi%
    \end{beamercolorbox}%
}

% Im horizontalen Modus ist die Footline die untere Hälfte des Titels
\defbeamertemplate{footline}{AAU 2025 title horizontal}{
    \begin{beamercolorbox}[ht=\dimexpr2\aaurowsep+2\aaurow+\aaubottom\relax,wd=\paperwidth,right,rightskip=\aauoutermargin]{title logo box}%
      \aautitlegrouplogo%
      \vskip\aaubottom
    \end{beamercolorbox}%
}

%% ┏━━━━━━━━━━━━━┓
%% ┃ /Titelseite ┃
%% ┗━━━━━━━━━━━━━┛

%% ┏━━━━━━━━┓
%% ┃ Farben ┃
%% ┗━━━━━━━━┛
%% aau-Farbschema

%todo: replace all AAU by AAU

% syssec color  red : 
\definecolor{syssec-red}{RGB}{212, 0,0}
\colorlet{syssec-red100}{syssec-red}
\colorlet{syssec-red90}{syssec-red!90!white}
\colorlet{syssec-red80}{syssec-red!80!white}
\colorlet{syssec-red70}{syssec-red!70!white}
\colorlet{syssec-red60}{syssec-red!60!white}
\colorlet{syssec-red50}{syssec-red!50!white}
\colorlet{syssec-red40}{syssec-red!40!white}
\colorlet{syssec-red30}{syssec-red!30!white}
\colorlet{syssec-red25}{syssec-red!25!white}
\colorlet{syssec-red20}{syssec-red!20!white}
\colorlet{syssec-red15}{syssec-red!15!white}
\colorlet{syssec-red10}{syssec-red!10!white}
\colorlet{syssec-red5}{syssec-red!5!white}

% AAU color blue:
\definecolor{aau-blue}{RGB}{10, 54, 94}
\colorlet{aau-blue100}{aau-blue}
\colorlet{aau-blue90}{aau-blue!90!white}
\colorlet{aau-blue80}{aau-blue!80!white}
\colorlet{aau-blue70}{aau-blue!70!white}
\colorlet{aau-blue60}{aau-blue!60!white}
\colorlet{aau-blue50}{aau-blue!50!white}
\colorlet{aau-blue40}{aau-blue!40!white}
\colorlet{aau-blue30}{aau-blue!30!white}
\colorlet{aau-blue25}{aau-blue!25!white}
\colorlet{aau-blue20}{aau-blue!20!white}
\colorlet{aau-blue15}{aau-blue!15!white}
\colorlet{aau-blue10}{aau-blue!10!white}
\colorlet{aau-blue5}{aau-blue!5!white}

%AAU royal blue
\definecolor{aau-gray}{RGB}{66, 107, 129}
\colorlet{aau-gray100}{aau-gray}
\colorlet{aau-gray90}{aau-gray!90!white}
\colorlet{aau-gray80}{aau-gray!80!white}
\colorlet{aau-gray70}{aau-gray!70!white}
\colorlet{aau-gray60}{aau-gray!60!white}
\colorlet{aau-gray50}{aau-gray!50!white}
\colorlet{aau-gray40}{aau-gray!40!white}
\colorlet{aau-gray30}{aau-gray!30!white}
\colorlet{aau-gray25}{aau-gray!25!white}
\colorlet{aau-gray20}{aau-gray!20!white}
\colorlet{aau-gray15}{aau-gray!15!white}
\colorlet{aau-gray10}{aau-gray!10!white}
\colorlet{aau-gray5}{aau-gray!5!white}

% Powerpoint-"Eisblau" (taken from Wörthersee)
\definecolor{aau-iceblue100}{RGB}{92, 200, 187}
\colorlet{aau-iceblue70}{aau-iceblue100!70!white}
\colorlet{aau-iceblue50}{aau-iceblue100!50!white}
\colorlet{aau-iceblue30}{aau-iceblue100!30!white}

% AAU color  red :
\definecolor{aau-red}{RGB}{235, 82, 76}
\colorlet{aau-red100}{aau-red}
\colorlet{aau-red90}{aau-red!90!white}
\colorlet{aau-red80}{aau-red!80!white}
\colorlet{aau-red70}{aau-red!70!white}
\colorlet{aau-red60}{aau-red!60!white}
\colorlet{aau-red50}{aau-red!50!white}
\colorlet{aau-red40}{aau-red!40!white}
\colorlet{aau-red30}{aau-red!30!white}
\colorlet{aau-red25}{aau-red!25!white}
\colorlet{aau-red20}{aau-red!20!white}
\colorlet{aau-red15}{aau-red!15!white}
\colorlet{aau-red10}{aau-red!10!white}
\colorlet{aau-red5}{aau-red!5!white}

% AAU color  yellow :
\definecolor{aau-yellow}{RGB}{244, 186, 85}
\colorlet{aau-yellow100}{aau-yellow}
\colorlet{aau-yellow90}{aau-yellow!90!white}
\colorlet{aau-yellow80}{aau-yellow!80!white}
\colorlet{aau-yellow70}{aau-yellow!70!white}
\colorlet{aau-yellow60}{aau-yellow!60!white}
\colorlet{aau-yellow50}{aau-yellow!50!white}
\colorlet{aau-yellow40}{aau-yellow!40!white}
\colorlet{aau-yellow30}{aau-yellow!30!white}
\colorlet{aau-yellow25}{aau-yellow!25!white}
\colorlet{aau-yellow20}{aau-yellow!20!white}
\colorlet{aau-yellow15}{aau-yellow!15!white}
\colorlet{aau-yellow10}{aau-yellow!10!white}
\colorlet{aau-yellow5}{aau-yellow!5!white}

% AAU color  orange :
\definecolor{aau-orange}{RGB}{234, 146, 53}
\colorlet{aau-orange100}{aau-orange}
\colorlet{aau-orange90}{aau-orange!90!white}
\colorlet{aau-orange80}{aau-orange!80!white}
\colorlet{aau-orange70}{aau-orange!70!white}
\colorlet{aau-orange60}{aau-orange!60!white}
\colorlet{aau-orange50}{aau-orange!50!white}
\colorlet{aau-orange40}{aau-orange!40!white}
\colorlet{aau-orange30}{aau-orange!30!white}
\colorlet{aau-orange25}{aau-orange!25!white}
\colorlet{aau-orange20}{aau-orange!20!white}
\colorlet{aau-orange15}{aau-orange!15!white}
\colorlet{aau-orange10}{aau-orange!10!white}
\colorlet{aau-orange5}{aau-orange!5!white}

% AAU color  green :
\definecolor{aau-green}{RGB}{106, 179, 71}
\colorlet{aau-green100}{aau-green}
\colorlet{aau-green90}{aau-green!90!white}
\colorlet{aau-green80}{aau-green!80!white}
\colorlet{aau-green70}{aau-green!70!white}
\colorlet{aau-green60}{aau-green!60!white}
\colorlet{aau-green50}{aau-green!50!white}
\colorlet{aau-green40}{aau-green!40!white}
\colorlet{aau-green30}{aau-green!30!white}
\colorlet{aau-green25}{aau-green!25!white}
\colorlet{aau-green20}{aau-green!20!white}
\colorlet{aau-green15}{aau-green!15!white}
\colorlet{aau-green10}{aau-green!10!white}
\colorlet{aau-green5}{aau-green!5!white}


% AAU color  purple : Tewi
\definecolor{aau-purple}{RGB}{84, 63, 145}
\colorlet{aau-purple100}{aau-purple}
\colorlet{aau-purple90}{aau-purple!90!white}
\colorlet{aau-purple80}{aau-purple!80!white}
\colorlet{aau-purple70}{aau-purple!70!white}
\colorlet{aau-purple60}{aau-purple!60!white}
\colorlet{aau-purple50}{aau-purple!50!white}
\colorlet{aau-purple40}{aau-purple!40!white}
\colorlet{aau-purple30}{aau-purple!30!white}
\colorlet{aau-purple25}{aau-purple!25!white}
\colorlet{aau-purple20}{aau-purple!20!white}
\colorlet{aau-purple15}{aau-purple!15!white}
\colorlet{aau-purple10}{aau-purple!10!white}
\colorlet{aau-purple5}{aau-purple!5!white}

% AAU color  brown : todo replace darkred
\definecolor{aau-brown}{RGB}{58, 112, 72}
\colorlet{aau-brown100}{aau-brown}
\colorlet{aau-brown90}{aau-brown!90!white}
\colorlet{aau-brown80}{aau-brown!80!white}
\colorlet{aau-brown70}{aau-brown!70!white}
\colorlet{aau-brown60}{aau-brown!60!white}
\colorlet{aau-brown50}{aau-brown!50!white}
\colorlet{aau-brown40}{aau-brown!40!white}
\colorlet{aau-brown30}{aau-brown!30!white}
\colorlet{aau-brown25}{aau-brown!25!white}
\colorlet{aau-brown20}{aau-brown!20!white}
\colorlet{aau-brown15}{aau-brown!15!white}
\colorlet{aau-brown10}{aau-brown!10!white}
\colorlet{aau-brown5}{aau-brown!5!white}

% AAU color  cyan :
\definecolor{aau-cyan}{RGB}{35, 161, 224}
\colorlet{aau-cyan100}{aau-cyan}
\colorlet{aau-cyan90}{aau-cyan!90!white}
\colorlet{aau-cyan80}{aau-cyan!80!white}
\colorlet{aau-cyan70}{aau-cyan!70!white}
\colorlet{aau-cyan60}{aau-cyan!60!white}
\colorlet{aau-cyan50}{aau-cyan!50!white}
\colorlet{aau-cyan40}{aau-cyan!40!white}
\colorlet{aau-cyan30}{aau-cyan!30!white}
\colorlet{aau-cyan25}{aau-cyan!25!white}
\colorlet{aau-cyan20}{aau-cyan!20!white}
\colorlet{aau-cyan15}{aau-cyan!15!white}
\colorlet{aau-cyan10}{aau-cyan!10!white}
\colorlet{aau-cyan5}{aau-cyan!5!white}

% AAU color  gray :
\definecolor{aau-gray}{RGB}{0,1, 0}
\colorlet{aau-gray100}{black}
\colorlet{aau-gray90}{black!90!white}
\colorlet{aau-gray80}{black!80!white}
\colorlet{aau-gray70}{black!70!white}
\colorlet{aau-gray60}{black!60!white}
\colorlet{aau-gray50}{black!50!white}
\colorlet{aau-gray40}{black!40!white}
\colorlet{aau-gray30}{black!30!white}
\colorlet{aau-gray25}{black!25!white}
\colorlet{aau-gray20}{black!20!white}
\colorlet{aau-gray15}{black!15!white}
\colorlet{aau-gray10}{black!10!white}
\colorlet{aau-gray5}{black!5!white}

%AAU royal blue
\definecolor{aau-royalblue}{RGB}{66, 107, 129}
\colorlet{aau-royalblue100}{aau-royalblue}
\colorlet{aau-royalblue90}{aau-royalblue!90!white}
\colorlet{aau-royalblue80}{aau-royalblue!80!white}
\colorlet{aau-royalblue70}{aau-royalblue!70!white}
\colorlet{aau-royalblue60}{aau-royalblue!60!white}
\colorlet{aau-royalblue50}{aau-royalblue!50!white}
\colorlet{aau-royalblue40}{aau-royalblue!40!white}
\colorlet{aau-royalblue30}{aau-royalblue!30!white}
\colorlet{aau-royalblue25}{aau-royalblue!25!white}
\colorlet{aau-royalblue20}{aau-royalblue!20!white}
\colorlet{aau-royalblue15}{aau-royalblue!15!white}
\colorlet{aau-royalblue10}{aau-royalblue!10!white}
\colorlet{aau-royalblue5}{aau-royalblue!5!white}


\setbeamercolor*{normal text}{fg=aau-gray}
\setbeamercolor*{alerted text}{fg=aau-red100}
\setbeamercolor*{example text}{fg=aau-gray}
\setbeamercolor*{structure}{fg=aau-gray90}
\setbeamercolor*{frametitle}{fg=syssec-red}
\setbeamercolor*{framesubtitle}{fg=aau-gray50}
\setbeamercolor*{footer}{fg=aau-iceblue50.fg}

\setbeamercolor*{palette primary}{fg=normal text.fg,bg=black!15}
\setbeamercolor*{palette secondary}{fg=normal text.fg,bg=black!15}
\setbeamercolor*{palette tertiary}{fg=normal text.fg,bg=black!15}
\setbeamercolor*{palette quaternary}{fg=normal text.fg,bg=black!15}

\setbeamercolor*{item projected}{fg=white,bg=syssec-red100}
\setbeamercolor*{itemize item}{fg=syssec-red100}
\setbeamercolor*{itemize subitem}{fg=syssec-red100}
\setbeamercolor*{itemize subsubitem}{fg=syssec-red100}

\setbeamercolor*{block title}{fg=white,bg=syssec-red100}
\setbeamercolor*{block title alerted}{use=alerted text,fg=white,bg=alerted text.fg!75!black}
\setbeamercolor*{block title example}{fg=white,bg=aau-gray}

\setbeamercolor*{red block}{bg=syssec-red100}
\setbeamercolor*{white block}{bg=white}
\setbeamercolor*{blue block}{bg=aau-gray100}

\setbeamercolor*{title on red}{fg=syssec-red20}
\setbeamercolor*{title on white}{fg=syssec-red100}

\setbeamercolor*{subtitle on red}{fg=white}
\setbeamercolor*{subtitle on white}{fg=normal text.fg}

\setbeamercolor*{block body}{fg=normal text.fg,bg=syssec-red15}
\setbeamercolor*{block body alerted}{parent=normal text,use=block title alerted,bg=block title alerted.bg!10!bg}
\setbeamercolor*{block body example}{fg=normal text.fg,bg=aau-blue15}

\setbeamercolor*{standard box}{fg=white,bg=syssec-red100}%
\setbeamercolor*{highlight box}{fg=white,bg=aau-gray100}%
\setbeamercolor*{highlight box gray}{fg=normal text.fg,bg=aau-iceblue50}%
\setbeamercolor*{highlight box lightgray}{fg=normal text.fg,bg=aau-iceblue30}%

\setbeamercolor*{standard box framed}{fg=syssec-red100,bg=}%
\setbeamercolor*{highlight box framed}{fg=aau-gray100,bg=}%
\setbeamercolor*{highlight box gray framed}{fg=aau-iceblue50,bg=}%

\setbeamercolor*{background canvas}{bg=white}

\setbeamercolor*{footer}{fg=aau-gray100!50!white}

\setbeamercolor*{mini frame}{fg=aau-gray100!50!white}
\setbeamercolor{section in head/foot}{fg=aau-gray100!50!white}

%% ┏━━━━━━━━━┓
%% ┃ /Farben ┃
%% ┗━━━━━━━━━┛

\setbeamertemplate{section in toc}{{\inserttocsectionnumber.~\inserttocsection}\\[.2em]}
\setbeamercolor{section in toc}{fg=aau-gray}
\setbeamerfont{section in toc}{size=\huge, series=\bfseries}
\setbeamerfont{subsection in toc}{size=\large}

%% ┏━━━━━━━━━━━━━━━━━━━━┓
%% ┃ Block-Definitionen ┃
%% ┗━━━━━━━━━━━━━━━━━━━━┛

% Original von tex/latex/beamer/beamerinnerthemedefault.sty
% colsep* durch colsep ersetzt, damit die Blöcke nicht über das Raster herausragen
\defbeamertemplate*{block begin}{AAU 2025}
{
  \par\vskip\medskipamount%
  \begin{beamercolorbox}[colsep=.75ex]{block title}
    \usebeamerfont*{block title}\insertblocktitle%
  \end{beamercolorbox}%
  {\parskip0pt\par}%
  \ifbeamercolorempty[bg]{block title}
  {}
  {\ifbeamercolorempty[bg]{block body}{}{\nointerlineskip\vskip-0.5pt}}%
  \usebeamerfont{block body}%
  \begin{beamercolorbox}[colsep=.75ex,vmode]{block body}%
    \ifbeamercolorempty[bg]{block body}{\vskip-.25ex}{\vskip-.75ex}\vbox{}%
}
\defbeamertemplate*{block end}{AAU 2025}  
{\end{beamercolorbox}\vskip\smallskipamount}

\defbeamertemplate*{block alerted begin}{AAU 2025}
{
  \par\vskip\medskipamount%
  \begin{beamercolorbox}[colsep=.75ex]{block title alerted}
    \usebeamerfont*{block title alerted}\insertblocktitle%
  \end{beamercolorbox}%
  {\parskip0pt\par}%
  \ifbeamercolorempty[bg]{block title alerted}
  {}
  {\ifbeamercolorempty[bg]{block body alerted}{}{\nointerlineskip\vskip-0.5pt}}%
  \usebeamerfont{block body alerted}%
  \begin{beamercolorbox}[colsep=.75ex,vmode]{block body alerted}%
    \ifbeamercolorempty[bg]{block body alerted}{\vskip-.25ex}{\vskip-.75ex}\vbox{}%
}

\defbeamertemplate*{block alerted end}{AAU 2025}
{\end{beamercolorbox}\vskip\smallskipamount}

\defbeamertemplate*{block example begin}{AAU 2025}
{
  \par\vskip\medskipamount%
  \begin{beamercolorbox}[colsep=.75ex]{block title example}
    \usebeamerfont*{block title example}\insertblocktitle%
  \end{beamercolorbox}%
  {\parskip0pt\par}%
  \ifbeamercolorempty[bg]{block title example}
  {}
  {\ifbeamercolorempty[bg]{block body example}{}{\nointerlineskip\vskip-0.5pt}}%
  \usebeamerfont{block body example}%
  \begin{beamercolorbox}[colsep=.75ex,vmode]{block body example}%
    \ifbeamercolorempty[bg]{block body example}{\vskip-.25ex}{\vskip-.75ex}\vbox{}%
}
\defbeamertemplate*{block example end}{AAU 2025}
{\end{beamercolorbox}\vskip\smallskipamount}

\setbeamertemplate{block begin}[AAU 2025]
\setbeamertemplate{block end}[AAU 2025]
\setbeamertemplate{block alerted begin}[AAU 2025]
\setbeamertemplate{block alerted end}[AAU 2025]
\setbeamertemplate{block example begin}[AAU 2025]
\setbeamertemplate{block example end}[AAU 2025]

% Content environment for structuring. Basically a headline followed by text
\newenvironment<>{contentblock}[1]{\begingroup%
  \setbeamertemplate{blocks}[default]
	\setbeamercolor{block body}{fg=normal text.fg,bg=}%
  \setbeamercolor{block title}{fg=normal text.fg,bg=}%
  \setbeamerfont*{block title}{family=\sffamily,series=\bfseries,size=\large}
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{royalblueblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-iceblue30!50}%
	\setbeamercolor{block title}{fg=white,bg=aau-gray100}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{grayblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-gray50!50}%
	\setbeamercolor{block title}{fg=white,bg=aau-gray50}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{lightgrayblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-gray30!50}%
	\setbeamercolor{block title}{fg=normal text.fg,bg=aau-gray30}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{redblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=syssec-red15}%
	\setbeamercolor{block title}{fg=white,bg=syssec-red100}%
	\begin{block}#2{#1}%
	}{\end{block}
\endgroup}

\newenvironment<>{blueblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-blue15}%
	\setbeamercolor{block title}{fg=white,bg=aau-blue100}%
	\begin{block}#2{#1}%
	}{\end{block}
\endgroup}

\newenvironment<>{aauredblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-red15}%
	\setbeamercolor{block title}{fg=white,bg=aau-red100}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{brownblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-brown15}%
	\setbeamercolor{block title}{fg=white,bg=aau-brown100}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{purpleblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-purple15}%
	\setbeamercolor{block title}{fg=white,bg=aau-purple100}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{yellowblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-yellow30}%
	\setbeamercolor{block title}{fg=normal text.fg,bg=aau-yellow100}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{greenblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-green15}%
	\setbeamercolor{block title}{fg=white,bg=aau-green100}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{orangeblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-orange15}%
	\setbeamercolor{block title}{fg=white,bg=aau-orange100}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

\newenvironment<>{cyanblock}[1]{\begingroup%
	\setbeamercolor{block body}{fg=normal text.fg,bg=aau-cyan15}%
	\setbeamercolor{block title}{fg=white,bg=aau-cyan100}%
	\begin{block}#2{#1}%
	}{\end{block}%
\endgroup}

%%
%% Boxen
%%

\newenvironment<>{standardbox}{%
  \begin{beamercolorbox}[sep=1em,center,vmode]{standard box}%
  \usebeamerfont{standard box}%
}{%
  \end{beamercolorbox}%
}

\newenvironment<>{highlightbox}{%
  \begin{beamercolorbox}[sep=1em,center,vmode]{highlight box}
  \usebeamerfont{highlight box}%
}{%
  \end{beamercolorbox}%
}

\newenvironment<>{grayhighlightbox}{%
  \begin{beamercolorbox}[sep=1em,center,vmode]{highlight box gray}
  \usebeamerfont{highlight box}%
}{%
  \end{beamercolorbox}%
}

\newenvironment<>{lightgrayhighlightbox}{%
  \begin{beamercolorbox}[sep=1em,center,vmode]{highlight box lightgray}
  \usebeamerfont{highlight box}%
}{%
  \end{beamercolorbox}%
}

%% ┏━━━━━━━━━━━━━━━━━━━━━┓
%% ┃ /Block-Definitionen ┃
%% ┗━━━━━━━━━━━━━━━━━━━━━┛

%% Appendix-Seiten zählen nicht in die Gesamtfolienzahl

\newcommand{\beginbackup}{
   \newcounter{framenumbervorappendix}
   \setcounter{framenumbervorappendix}{\value{framenumber}}
}
\newcommand{\backupend}{
   \addtocounter{framenumbervorappendix}{-\value{framenumber}}
   \addtocounter{framenumber}{\value{framenumbervorappendix}} 
}